/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.RAM128k;
import jace.apple2e.SoftSwitches;
import jace.apple2e.VideoDHGR;
import jace.config.ConfigurableField;
import jace.core.Computer;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.Video;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.HashSet;
import java.util.Set;

public class VideoNTSC
extends VideoDHGR {
    @ConfigurableField(name="Text palette", shortName="textPalette", defaultValue="false", description="Use text-friendly color palette")
    public static boolean useTextPalette = false;
    static int[][] activePalette;
    @ConfigurableField(name="Video 7", shortName="video7", defaultValue="true", description="Enable Video 7 RGB rendering support")
    public static boolean enableVideo7;
    int[] scanline = new int[20];
    static int[] divBy28;
    int pos = 0;
    int lastKnownY = -1;
    boolean colorActive = false;
    int rowStart = 0;
    static int[][] pyOffset;
    public static final double MIN_Y = 0.0;
    public static final double MAX_Y = 1.0;
    public static final double MAX_I = 0.5957;
    public static final double MAX_Q = 0.5226;
    static int[][] solidPalette;
    static int[][] textPalette;
    static double[][] yiq;
    rgbMode graphicsMode = rgbMode.color;
    boolean f1 = true;
    boolean f2 = true;
    boolean an3 = true;
    static Set<RAMListener> rgbStateListeners;

    @Override
    protected void showBW(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        if (this.lastKnownY != y) {
            this.lastKnownY = y;
            this.pos = this.rowStart = divBy28[xOffset];
            this.colorActive = false;
        } else if (this.pos > 20) {
            this.pos -= 20;
        }
        this.doDisplay(screen, xOffset, y, dhgrWord);
    }

    @Override
    protected void showDhgr(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        if (this.lastKnownY != y) {
            this.lastKnownY = y;
            this.pos = this.rowStart = divBy28[xOffset];
            this.colorActive = true;
        }
        this.doDisplay(screen, xOffset, y, dhgrWord);
    }

    @Override
    protected void displayLores(BufferedImage screen, int xOffset, int y, int rowAddress) {
        if ((xOffset & 1) == 1) {
            return;
        }
        if (this.lastKnownY != y) {
            this.lastKnownY = y;
            this.pos = this.rowStart = divBy28[xOffset];
            this.colorActive = true;
        }
        int c1 = ((RAM128k)Computer.getComputer().getMemory()).getMainMemory().readByte(rowAddress + xOffset) & 0xFF;
        c1 = (y & 7) < 4 ? (c1 &= 0xF) : (c1 >>= 4);
        int c2 = ((RAM128k)Computer.getComputer().getMemory()).getMainMemory().readByte(rowAddress + xOffset + 1) & 0xFF;
        c2 = (y & 7) < 4 ? (c2 &= 0xF) : (c2 >>= 4);
        int pat = c1 | c1 << 4 | c1 << 8 | (c1 & 3) << 12;
        this.scanline[this.pos++] = pat |= (c2 & 0xC) << 12 | c2 << 16 | c2 << 20 | c2 << 24;
    }

    private void doDisplay(BufferedImage screen, int xOffset, int y, int dhgrWord) {
        this.scanline[this.pos] = dhgrWord;
        ++this.pos;
    }

    @Override
    public void hblankStart(BufferedImage screen, int y, boolean isDirty) {
        if (isDirty) {
            this.renderScanline(screen, y);
        }
        this.lastKnownY = -1;
    }

    private void renderScanline(BufferedImage screen, int y) {
        block18: {
            DataBuffer b = screen.getRaster().getDataBuffer();
            try {
                int p = pyOffset[y][this.rowStart];
                if (this.rowStart > 0) {
                    this.getCurrentWriter().markDirty(y);
                }
                if (this.colorActive && (!this.dhgrMode || !enableVideo7 || this.graphicsMode.isColor())) {
                    int byteCounter = 0;
                    for (int s = this.rowStart; s < 20; ++s) {
                        int i;
                        int add = 0;
                        int bits = 0;
                        if (this.hiresMode) {
                            bits = this.scanline[s] << 2;
                            if (s > 0) {
                                bits |= this.scanline[s - 1] >> 26 & 3;
                            }
                        } else {
                            bits = this.scanline[s] << 3;
                            if (s > 0) {
                                bits |= this.scanline[s - 1] >> 25 & 7;
                            }
                        }
                        if (s < 19) {
                            add = this.scanline[s + 1] & 7;
                        }
                        boolean isBW = false;
                        if (enableVideo7 && this.dhgrMode && this.graphicsMode == rgbMode.mix) {
                            for (i = 0; i < 28; ++i) {
                                if (i % 7 == 0) {
                                    isBW = !this.hiresMode && !this.useColor[byteCounter];
                                    ++byteCounter;
                                }
                                if (isBW) {
                                    b.setElem(p++, (bits & 8) == 0 ? BLACK : WHITE);
                                } else {
                                    b.setElem(p++, activePalette[i % 4][bits & 0x7F]);
                                }
                                bits >>= 1;
                                if (i != 20) continue;
                                bits |= add << (this.hiresMode ? 9 : 10);
                            }
                            continue;
                        }
                        for (i = 0; i < 28; ++i) {
                            b.setElem(p++, activePalette[i % 4][bits & 0x7F]);
                            bits >>= 1;
                            if (i != 20) continue;
                            bits |= add << (this.hiresMode ? 9 : 10);
                        }
                    }
                    break block18;
                }
                for (int s = this.rowStart; s < 20; ++s) {
                    int bits = this.scanline[s];
                    for (int i = 0; i < 28; ++i) {
                        b.setElem(p++, (bits & 1) == 0 ? BLACK : WHITE);
                        bits >>= 1;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.getCurrentWriter().markDirty(y);
            }
        }
    }

    public static int yiqToRgb(double y, double i, double q) {
        int r = (int)(VideoNTSC.normalize(y + 0.956 * i + 0.621 * q, 0.0, 1.0) * 255.0);
        int g = (int)(VideoNTSC.normalize(y - 0.272 * i - 0.647 * q, 0.0, 1.0) * 255.0);
        int b = (int)(VideoNTSC.normalize(y - 1.105 * i + 1.702 * q, 0.0, 1.0) * 255.0);
        return r << 16 | g << 8 | b;
    }

    public static double normalize(double x, double minX, double maxX) {
        if (x < minX) {
            return minX;
        }
        if (x > maxX) {
            return maxX;
        }
        return x;
    }

    @Override
    public void reconfigure() {
        this.detach();
        activePalette = useTextPalette ? textPalette : solidPalette;
        super.reconfigure();
        this.attach();
    }

    public void rgbStateChange(ModeStateChanges state) {
        switch (state) {
            case CLEAR_80: {
                break;
            }
            case CLEAR_AN3: {
                this.an3 = false;
                break;
            }
            case SET_80: {
                break;
            }
            case SET_AN3: {
                if (!this.an3) {
                    this.f2 = this.f1;
                    this.f1 = SoftSwitches._80COL.getState();
                }
                this.an3 = true;
            }
        }
        this.graphicsMode = this.f1 ? (this.f2 ? rgbMode.color : rgbMode.mix) : (this.f2 ? rgbMode.color : rgbMode.bw);
    }

    @Override
    public void detach() {
        super.detach();
        for (RAMListener l : rgbStateListeners) {
            Computer.getComputer().getMemory().removeListener(l);
        }
    }

    @Override
    public void attach() {
        super.attach();
        for (RAMListener l : rgbStateListeners) {
            Computer.getComputer().getMemory().addListener(l);
        }
    }

    static {
        enableVideo7 = false;
        divBy28 = new int[560];
        for (int i = 0; i < 560; ++i) {
            VideoNTSC.divBy28[i] = i / 28;
        }
        pyOffset = new int[192][21];
        for (int y = 0; y < 192; ++y) {
            for (int p = 0; p < 21; ++p) {
                VideoNTSC.pyOffset[y][p] = y * 560 + p * 28;
            }
        }
        solidPalette = new int[4][128];
        textPalette = new int[4][128];
        yiq = new double[][]{{0.0, 0.0, 0.0}, {0.25, 0.5, 0.5}, {0.25, -0.5, 0.5}, {0.5, 0.0, 1.0}, {0.25, -0.5, -0.5}, {0.5, 0.0, 0.0}, {0.5, -1.0, 0.0}, {0.75, -0.5, 0.5}, {0.25, 0.5, -0.5}, {0.5, 1.0, 0.0}, {0.5, 0.0, 0.0}, {0.75, 0.5, 0.5}, {0.5, 0.0, -1.0}, {0.75, 0.5, -0.5}, {0.75, -0.5, -0.5}, {1.0, 0.0, 0.0}};
        int maxLevel = 10;
        for (int offset = 0; offset < 4; ++offset) {
            for (int pattern = 0; pattern < 128; ++pattern) {
                int level = (pattern & 1) + (pattern >> 1 & 1) * 1 + (pattern >> 2 & 1) * 2 + (pattern >> 3 & 1) * 4 + (pattern >> 4 & 1) * 2 + (pattern >> 5 & 1) * 1;
                int col = pattern >> 2 & 0xF;
                for (int rot = 0; rot < offset; ++rot) {
                    col = (col & 8) >> 3 | col << 1 & 0xF;
                }
                double y1 = yiq[col][0];
                double y2 = (double)level / (double)maxLevel;
                VideoNTSC.solidPalette[offset][pattern] = 0xFF000000 | VideoNTSC.yiqToRgb(y1, yiq[col][1] * 0.5957, yiq[col][2] * 0.5226);
                VideoNTSC.textPalette[offset][pattern] = 0xFF000000 | VideoNTSC.yiqToRgb(y2, yiq[col][1] * 0.5957, yiq[col][2] * 0.5226);
            }
        }
        activePalette = solidPalette;
        rgbStateListeners = new HashSet<RAMListener>();
        rgbStateListeners.add(new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(49246);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Video v = Computer.getComputer().getVideo();
                if (v instanceof VideoNTSC) {
                    ((VideoNTSC)v).rgbStateChange(ModeStateChanges.CLEAR_AN3);
                }
            }
        });
        rgbStateListeners.add(new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(49247);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Video v = Computer.getComputer().getVideo();
                if (v instanceof VideoNTSC) {
                    ((VideoNTSC)v).rgbStateChange(ModeStateChanges.SET_AN3);
                }
            }
        });
        rgbStateListeners.add(new RAMListener(RAMEvent.TYPE.EXECUTE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(64098);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Video v = Computer.getComputer().getVideo();
                if (v instanceof VideoNTSC) {
                    ((VideoNTSC)v).f1 = true;
                    ((VideoNTSC)v).f2 = true;
                    ((VideoNTSC)v).an3 = false;
                    ((VideoNTSC)v).graphicsMode = rgbMode.color;
                }
            }
        });
        rgbStateListeners.add(new RAMListener(RAMEvent.TYPE.WRITE, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(49165);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                Video v = Computer.getComputer().getVideo();
                if (v instanceof VideoNTSC) {
                    ((VideoNTSC)v).rgbStateChange(ModeStateChanges.SET_80);
                }
            }
        });
    }

    public static enum ModeStateChanges {
        SET_AN3,
        CLEAR_AN3,
        SET_80,
        CLEAR_80;

    }

    public static enum rgbMode {
        color(true),
        mix(true),
        bw(false),
        _160col(false);

        boolean colorMode = false;

        private rgbMode(boolean c) {
            this.colorMode = c;
        }

        public boolean isColor() {
            return this.colorMode;
        }
    }
}

